/*!
 * stack-admin-theme (https://pixinvent.com/bootstrap-admin-template/stack)
 * Copyright 2018 PIXINVENT
 * Licensed under the Themeforest Standard Licenses
 */
$(window).on("load",function(){function createVisualization(json){initializeBreadcrumbTrail(),drawLegend(),d3.select("#togglelegend").on("click",toggleLegend),vis.append("svg:circle").attr("r",radius).style("opacity",0);var nodes=partition.nodes(json).filter(function(d){return d.dx>.005}),path=vis.data([json]).selectAll("path").data(nodes).enter().append("svg:path").attr("display",function(d){return d.depth?null:"none"}).attr("d",arc).attr("fill-rule","evenodd").style("fill",function(d){return colors[d.name]}).style("opacity",1).on("mouseover",mouseover);d3.select("#container").on("mouseleave",mouseleave),totalSize=path.node().__data__.value}function mouseover(d){var percentage=(100*d.value/totalSize).toPrecision(3),percentageString=percentage+"%";percentage<.1&&(percentageString="< 0.1%"),d3.select("#percentage").text(percentageString),d3.select("#explanation").style("visibility","");var sequenceArray=getAncestors(d);updateBreadcrumbs(sequenceArray,percentageString),ele.selectAll("path").style("opacity",.3),vis.selectAll("path").filter(function(node){return sequenceArray.indexOf(node)>=0}).style("opacity",1)}function mouseleave(d){d3.select("#trail").style("visibility","hidden"),ele.selectAll("path").on("mouseover",null),ele.selectAll("path").transition().duration(1e3).style("opacity",1).each("end",function(){d3.select(this).on("mouseover",mouseover)}),d3.select("#explanation").style("visibility","hidden")}function getAncestors(node){for(var path=[],current=node;current.parent;)path.unshift(current),current=current.parent;return path}function initializeBreadcrumbTrail(){var trail=d3.select("#sequence").append("svg:svg").attr("width",width).attr("height",50).attr("id","trail");trail.append("svg:text").attr("id","endlabel").style("fill","#000")}function breadcrumbPoints(d,i){var points=[];return points.push("0,0"),points.push(b.w+",0"),points.push(b.w+b.t+","+b.h/2),points.push(b.w+","+b.h),points.push("0,"+b.h),i>0&&points.push(b.t+","+b.h/2),points.join(" ")}function updateBreadcrumbs(nodeArray,percentageString){var g=d3.select("#trail").selectAll("g").data(nodeArray,function(d){return d.name+d.depth}),entering=g.enter().append("svg:g");entering.append("svg:polygon").attr("points",breadcrumbPoints).style("fill",function(d){return colors[d.name]}),entering.append("svg:text").attr("x",(b.w+b.t)/2).attr("y",b.h/2).attr("dy","0.35em").attr("text-anchor","middle").text(function(d){return d.name}),g.attr("transform",function(d,i){return"translate("+i*(b.w+b.s)+", 0)"}),g.exit().remove(),d3.select("#trail").select("#endlabel").attr("x",(nodeArray.length+.5)*(b.w+b.s)).attr("y",b.h/2).attr("dy","0.35em").attr("text-anchor","middle").text(percentageString),d3.select("#trail").style("visibility","")}function drawLegend(){var li={w:75,h:30,s:3,r:3},legend=d3.select("#legend").append("svg:svg").attr("width",li.w).attr("height",d3.keys(colors).length*(li.h+li.s)),g=legend.selectAll("g").data(d3.entries(colors)).enter().append("svg:g").attr("transform",function(d,i){return"translate(0,"+i*(li.h+li.s)+")"});g.append("svg:rect").attr("rx",li.r).attr("ry",li.r).attr("width",li.w).attr("height",li.h).style("fill",function(d){return d.value}),g.append("svg:text").attr("x",li.w/2).attr("y",li.h/2).attr("dy","0.35em").attr("text-anchor","middle").text(function(d){return d.key})}function toggleLegend(){var legend=d3.select("#legend");"hidden"==legend.style("visibility")?legend.style("visibility",""):legend.style("visibility","hidden")}function buildHierarchy(csv){for(var root={name:"root",children:[]},i=0;i<csv.length;i++){var sequence=csv[i][0],size=+csv[i][1];if(!isNaN(size))for(var parts=sequence.split("-"),currentNode=root,j=0;j<parts.length;j++){var childNode,children=currentNode.children,nodeName=parts[j];if(j+1<parts.length){for(var foundChild=!1,k=0;k<children.length;k++)if(children[k].name==nodeName){childNode=children[k],foundChild=!0;break}foundChild||(childNode={name:nodeName,children:[]},children.push(childNode)),currentNode=childNode}else childNode={name:nodeName,size:size},children.push(childNode)}}return root}var ele=d3.select("#sunburst-sequence"),width=ele.node().getBoundingClientRect().width,height=400,radius=Math.min(width,height)/2,b={w:75,h:30,s:3,t:10},colors={home:"#99B898",product:"#FECEA8",search:"#FF847C",account:"#E84A5F",other:"#6C5B7B",end:"#355C7D"},totalSize=0,vis=ele.append("svg:svg").attr("width",width).attr("height",height).append("svg:g").attr("id","container").attr("transform","translate("+width/2+","+height/2+")"),partition=d3.layout.partition().size([2*Math.PI,radius*radius]).value(function(d){return d.size}),arc=d3.svg.arc().startAngle(function(d){return d.x}).endAngle(function(d){return d.x+d.dx}).innerRadius(function(d){return Math.sqrt(d.y)}).outerRadius(function(d){return Math.sqrt(d.y+d.dy)});d3.text("app-assets/data/d3/circle/visit-sequences.csv",function(text){var csv=d3.csv.parseRows(text),json=buildHierarchy(csv);createVisualization(json)})});