//+------------------------------------------------------------------+
//|                                              SpareCashBridge.mq4 |
//|                                     Copyright 2023, SpareCashSRL |
//|                                         https://www.sparecash.ai |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, SpareCashSRL"
#property link      "https://www.sparecash.ai"
#property version   "1.0"
#property strict

//--- input parameters
input int         magicNumber = 1010;         // Enter Magic
input string      RobotName = "RobotName";    // Enter Your Robot Name From Setup Email
input double      LotSize = 10;               // Number of Contracts To Trade
//--- Margin Selection
enum MarginS
  {
   OneToOne = 1,      // 1:1
   TwoToOne = 2,      // 2:1
   FiveToOne = 5,     // 5:1
   TenToOne = 10,     // 10:1
   TwentyToOne = 20,  // 20:1
   ThirtyToOne = 30,  // 30:1
   FiftyToOne = 50,   // 50:1
   HundredToOne = 100 // 100:1
  };
input MarginS MarginA = ThirtyToOne;

//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   //--- Create Blank File
   string newfilestuff = "00/00/00,00:00,USDJPY,HOLD,1,1";
   int newfile = FileOpen(RobotName + "_symbolsig.txt", FILE_WRITE | FILE_TXT);
   if (newfile != INVALID_HANDLE)
     {
      FileWrite(newfile, newfilestuff);
      FileClose(newfile);
     }
   else
     {
      Print("Error creating file: ", GetLastError());
     }
   
   //--- create timer
   EventSetTimer(30);
   
   return(INIT_SUCCEEDED);
  }

//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   //--- destroy timer
   EventKillTimer();
  }

//+------------------------------------------------------------------+
//| Timer function                                                   |
//+------------------------------------------------------------------+
void OnTimer()
  {
   // string headers = "Content-Type: application/x-www-form-urlencoded\r\n";
   char post[],result[];
   string cookie=NULL,headers;
   // string result_headers;
   string bridge_url = "https://www.aitradingrobot.shop/MT5/SpareCashBridge/" + RobotName + "/" + RobotName + ".txt";
   int timeout = 10000;
   int res;
   // Updated WebRequest function call
   res = WebRequest("GET", bridge_url, cookie,NULL,timeout,post,0,result,headers);
   
   if (res == -1)
     {
      Print("Error in WebRequest. Error code =", GetLastError());
      MessageBox("Add the address '" + bridge_url + "' in the list of allowed URLs on tab 'Expert Advisors'", "Error", MB_ICONINFORMATION);
     }
   else
     {
      string line = CharArrayToString(result);
      string thearray[];
      int k = StringSplit(line, ',', thearray);
      
      if (k > 1)
        {
         string date = thearray[0];
         string time = thearray[1];
         string epic = thearray[2];
         string signal = thearray[3];
         string VolNow = thearray[5];
         string MAXsize = thearray[4];
         
         //--- Load the existing file
         int filehandle = FileOpen(RobotName + "_symbolsig.txt", FILE_READ | FILE_TXT);
         if (filehandle != INVALID_HANDLE)
           {
            string oldData = FileReadString(filehandle);
            FileClose(filehandle);
            
            string oldarray[];
            int yy = StringSplit(oldData, ',', oldarray);
            if (yy > 1)
              {
               string oldSIGN = oldarray[3];
               
               //--- Compare signals and take action
               if (oldSIGN != signal)
                 {
                  Alert(RobotName + " has SOMETHING DIFFERENT: " + signal + " was " + oldSIGN);
                 
                   
                  // Close existing positions if needed
                  ClosePosition(magicNumber, signal, oldSIGN);
                  
                  // Place new order based on the signal
                  PlaceOrder(signal, LotSize, magicNumber);
                 }
              }
           }
         
         //--- Write new data to file
         int filehandle1 = FileOpen(RobotName + "_symbolsig.txt", FILE_WRITE | FILE_TXT);
         if (filehandle1 != INVALID_HANDLE)
           {
            FileWrite(filehandle1, line);
            FileClose(filehandle1);
           }
        }
     }
  }

//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
   //--- Implement OnTick logic here if needed
  }

//+------------------------------------------------------------------+
//| Custom function for closing positions                            |
//+------------------------------------------------------------------+
void ClosePosition(int magicNumber, string signal, string oldSIGN)
  {
   for (int i = OrdersTotal() - 1; i >= 0; i--)
     {
      if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES))
        {
         if (OrderMagicNumber() == magicNumber && OrderSymbol() == Symbol())
           {
            if ((signal == "TPB" && oldSIGN == "LONG") || (signal == "TPS" && oldSIGN == "SHORT") || (signal == "SHORT" && oldSIGN == "LONG") || (signal == "LONG" && oldSIGN == "SHORT"))
              {
               if (OrderType() == OP_BUY || OrderType() == OP_SELL)
                 {
                  if (OrderClose(OrderTicket(), OrderLots(), OrderClosePrice(), 3, clrRed))
                    {
                     Print(RobotName + " Position Closed");
                    }
                 }
              }
           }
        }
     }
  }

//+------------------------------------------------------------------+
//| Custom function for placing orders                               |
//+------------------------------------------------------------------+
void PlaceOrder(string signal, double lotSize, int magicNumber)
  {
   int ticket;
   if (signal == "LONG")
     {
      ticket = OrderSend(Symbol(), OP_BUY, lotSize, Ask, 3, 0, 0, RobotName, magicNumber, 0, clrGreen);
      if (ticket < 0)
        {
         Print("Error opening buy order: ", GetLastError());
        }
      else
        {
         Print(RobotName + " LONG Order Sent with Magic: " + magicNumber + " and Lots: " + lotSize);
        //Sleep(3000); // Wait for 3 seconds
         //OrderClosePartial(ticket, 0.01);
        }
     }
   else if (signal == "SHORT")
     {
      ticket = OrderSend(Symbol(), OP_SELL, lotSize, Bid, 3, 0, 0, RobotName, magicNumber, 0, clrRed);
      if (ticket < 0)
        {
         Print("Error opening sell order: ", GetLastError());
        }
      else
        {
         Print(RobotName + " SHORT Order Sent with Magic: " + magicNumber + " and Lots: " + lotSize);
         //Sleep(3000); // Wait for 3 seconds
         //OrderClosePartial(ticket, 0.01);
        }
     }
  }
  //+------------------------------------------------------------------+
//| Custom function for partial closing of an order                  |
//+------------------------------------------------------------------+
bool OrderClosePartial(int ticket, double lots)
  {
   if (OrderSelect(ticket, SELECT_BY_TICKET))
     {
      if (OrderClose(ticket, lots, OrderClosePrice(), 3, clrBlue))
        {
         Print("Partial close of ", lots, " lots successful for order: ", ticket);
         return(true);
        }
      else
        {
         Print("Error closing partial order: ", GetLastError());
         return(false);
        }
     }
   return(false);
  }